/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.server.wizard.EditServerLocationWizard;

public class ServerEditAction
extends SelectionProviderAction {
    private List<IServer> servers;
    private Shell shell;

    public ServerEditAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionEdit);
        this.shell = shell;
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.servers = new ArrayList<IServer>();
        for (Object obj : sel) {
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                this.servers.add(server);
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.servers.size() == 1);
    }

    public void run() {
        IStructuredSelection sel;
        if (this.servers == null && (sel = this.getStructuredSelection()) != null) {
            this.selectionChanged(sel);
        }
        if (this.servers != null && !this.servers.isEmpty()) {
            ServerEditAction.openEditWizard(this.shell, this.servers.get(0));
        }
    }

    public static void openEditWizard(Shell shell, IServer server) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelection selection = workbenchWindow.getSelectionService().getSelection();
        Object selectionToPass = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        EditServerLocationWizard wizard = new EditServerLocationWizard(server);
        wizard.init(workbench, (IStructuredSelection)selectionToPass);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }
}

